/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ----------------------------------------------------------*/
/* This file contains definitions for the pattern parser of  */
/* that are needed for dynamic capabilities and onboard firm-*/
/* ware. This file is included into dynamic.c and pattparse  */
/* files ONLY!!! */
/* Author: Tilmann Wendel */
/* ----------------------------------------------------------*/

/* ----------------------------------------------- */
/* pattern GUI needs some string lists too         */
/* ----------------------------------------------- */


/* special command list for pattern editor puposes */
#ifdef FIRMWARE_REAL_COMPILE
static const
#endif
#ifdef FIRMWARE_UX_COMPILE
extern
#endif
b_param_stringlisttype xact_patt_table[]
#ifdef FIRMWARE_UX_COMPILE
;
#else
 = {
  { "Int_Ack",              0 },
  { "Special",              1 },
  { "IO_Read",              2 },
  { "IO_Write",             3 },
  { "Reserved_4",           4 },
  { "Reserved_5",           5 },
  { "Mem_Read",             6 },
  { "Mem_Write",            7 },
  { "Reserved_8",           8 },
  { "Reserved_9",           9 },
  { "Config_Read",         10 },
  { "Config_Write",        11 },
  { "Mem_ReadMultiple",    12 },
  { "DAC",                 13 },
  { "Mem_ReadLine",        14 },
  { "Mem_WriteInvalidate", 15 },
  { "DONT CARE",           16 },
  { NULL, 0 }
};
#endif

/* standard choice for pattern strings */
#ifdef FIRMWARE_REAL_COMPILE
static const
#endif
#ifdef FIRMWARE_UX_COMPILE
extern
#endif
b_param_stringlisttype std_patt_table[]
#ifdef FIRMWARE_UX_COMPILE
;
#else
 = {
  { "0",              0 },
  { "1",              1 },
  { "x",              2 },  /* GUI needs 'x', not a 'X' here ! */
  { NULL,             0 }
};
#endif


/* bus state choice for pattern strings */
#ifdef FIRMWARE_REAL_COMPILE
static const
#endif
#ifdef FIRMWARE_UX_COMPILE
extern
#endif
b_param_stringlisttype bstate_patt_table[]
#ifdef FIRMWARE_UX_COMPILE
;
#else
 = {
  { "Unsync",            0 },
  { "Idle",              1 },
  { "DAC1",              2 },
  { "Addr",              3 },
  { "DAC2",              4 },
  { "Decode",            5 },
  { "Wait",              6 },
  { "Transfer",          7 },
  { "DONT CARE",         8 },
  { NULL,                0 }
};
#endif

/* burst order choice for pattern strings */
#ifdef FIRMWARE_REAL_COMPILE
static const
#endif
#ifdef FIRMWARE_UX_COMPILE
extern
#endif
b_param_stringlisttype x_burst_patt_table[]
#ifdef FIRMWARE_UX_COMPILE
;
#else
 = {
  { "Linear",            0 },
  { "Cachline Wrap",     1 },
  { "DONT CARE",         2 },
  { NULL,                0 }
};
#endif

/* term choice for pattern strings */
#ifdef FIRMWARE_REAL_COMPILE
static const
#endif
#ifdef FIRMWARE_UX_COMPILE
extern
#endif
b_param_stringlisttype term_patt_table[]
#ifdef FIRMWARE_UX_COMPILE
;
#else
 = {
  { "no_term",            0 },
  { "m_abort",            1 },
  { "m_complete",         2 },
  { "t_disconn_A",        3 },
  { "t_disconn_B",        4 },
  { "t_disc_retry1",      5 },
  { "t_disc_retry2",      6 },
  { "t_abort",            7 },
  { "DONT CARE",          8 },
  { NULL,                 0 }
};
#endif

/* burst choice for pattern strings */
#ifdef FIRMWARE_REAL_COMPILE
static const
#endif
#ifdef FIRMWARE_UX_COMPILE
extern
#endif
b_param_stringlisttype burst_patt_table[]
#ifdef FIRMWARE_UX_COMPILE
;
#else
 = {
  { "invalid",            0 },
  { "single",             1 },
  { "first",              2 },
  { "middle",             3 },
  { "last",               4 },
  { "DONT CARE",          5 },
  { NULL,                 0 }
};
#endif

/* decode choice for pattern strings */
#ifdef FIRMWARE_REAL_COMPILE
static const
#endif
#ifdef FIRMWARE_UX_COMPILE
extern
#endif
b_param_stringlisttype decode_patt_table[]
#ifdef FIRMWARE_UX_COMPILE
;
#else
 = {
  { "dont_know",            0 },
  { "fast",                 1 },
  { "medium",               2 },
  { "slow",                 3 },
  { "subtractive",          4 },
  { "too_slow",             5 },
  { "DONT CARE",            6 },
  { NULL,                   0 }
};
#endif


/* ------------------------------------------------------- */
#define NO_BIT_POS         0xffffffff

typedef struct {       
  char *                         Name; 
  unsigned long                  MinVal; 
  unsigned long                  MaxVal; 
  unsigned long                  BitCount; 
  unsigned long                  GUIUsageCode; 
  unsigned long                  MemPosStd; 
  unsigned long                  MemPosFast; 
  unsigned long                  MemPosTran; 
#ifdef FIRMWARE_REAL_COMPILE
  const
#endif
  b_param_stringlisttype * StringList; 
} b_patt_infotype; 


/* no difference between e2926 with and without deep trace */
#ifdef FIRMWARE_UX_COMPILE
extern b_patt_infotype e2926a_patt_signal_table[];
#else
#ifdef FIRMWARE_REAL_COMPILE
static
#endif
const b_patt_infotype e2926a_patt_signal_table[] = {
 {"AD64",         0, 0xffffffff, 32, B_PATT_STD | B_PATT_COND,                   0x00,       0x00,       0x00,  NULL          },
 {"AD32",         0, 0xffffffff, 32, B_PATT_STD | B_PATT_COND,                   0x20,       0x20,       0x20,  NULL          },
 {"CBE7_4",       0, 0xf,         4, B_PATT_STD | B_PATT_COND,                   0x44,       0x44,       0x44,  NULL          },
 {"CBE3_0",       0, 0xf,         4, B_PATT_STD | B_PATT_COND,                   0x40,       0x40,       0x40,  NULL          },
 {"FRAME",        0, 0x7,         1, B_PATT_STD | B_PATT_COND,                   0x50,       0x50,       0x50,  std_patt_table},
 {"IRDY",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x51,       0x51,       0x51,  std_patt_table},
 {"TRDY",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x52,       0x52,       0x52,  std_patt_table},
 {"STOP",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x55,       0x55,       0x55,  std_patt_table},
 {"DEVSEL",       0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x53,       0x53,       0x53,  std_patt_table},
 {"b_state",      0, 0x7,         3, B_PATT_STD,                                0x188, NO_BIT_POS,      0x148,  bstate_patt_table},
 {"xact_cmd",     0, 0xf,         4, B_PATT_STD               | B_PATT_SQ,      0x170, NO_BIT_POS, NO_BIT_POS,  xact_patt_table},
 {"PAR",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5A,       0x5A,       0x5A,  std_patt_table},
 {"t_act",        0, 0x1,         1, B_PATT_STD               | B_PATT_SQ,       0xC1, NO_BIT_POS,       0x64,  std_patt_table},
 {"m_act",        0, 0x1,         1, B_PATT_STD               | B_PATT_SQ,       0xC0, NO_BIT_POS,       0x62,  std_patt_table},
 {"m_lock",       0, 0x1,         1, B_PATT_STD,                                 0xC2, NO_BIT_POS,       0x63,  std_patt_table},
 {"t_lock",       0, 0x1,         1, B_PATT_STD,                                 0xC3, NO_BIT_POS,       0x65,  std_patt_table},
 {"xact_rq64",    0, 0x1,         1, B_PATT_STD               | B_PATT_SQ,       0x4E, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_burst",   0, 0x3,         2, B_PATT_STD,                                0x16C, NO_BIT_POS, NO_BIT_POS,  x_burst_patt_table},
 {"term",         0, 0x7,         3, B_PATT_STD,                                0x180, NO_BIT_POS, NO_BIT_POS,  term_patt_table},
 {"burst",        0, 0x4,         3, B_PATT_STD,                                0x1B8, NO_BIT_POS, NO_BIT_POS,  burst_patt_table},
 {"decode",       0, 0x5,         3, B_PATT_STD,                                0x1B0, NO_BIT_POS, NO_BIT_POS,  decode_patt_table},
 {"xact_lock",    0, 0x1,         1, B_PATT_STD,                                 0xDF, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_dac",     0, 0x1,         1, B_PATT_STD,                                 0xDE, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_fb2b",    0, 0x1,         1, B_PATT_STD,                                 0xDD, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"master_done",  0, 0x1,         1, B_PATT_STD,                                 0xC4, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"addr_lt_ul",   0, 0x1,         1, 0,                                          0xC6, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"addr_bt_ll",   0, 0x1,         1, 0,                                          0xC5, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"addr_phase",   0, 0x1,         1,              B_PATT_COND,             NO_BIT_POS,       0x6A, NO_BIT_POS,  std_patt_table},
 {"ACK64",        0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x4D,       0x4D,       0x61,  std_patt_table},
 {"REQ64",        0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x4C,       0x4C,       0x60,  std_patt_table},
 {"PAR64",        0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x4B,       0x4B,       0x7F,  std_patt_table},
 {"RST",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5B,       0x5B,       0x5B,  std_patt_table},
 {"LOCK",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x48,       0x48,       0x7C,  std_patt_table},
 {"GNT",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x57,       0x57,       0x57,  std_patt_table},
 {"REQ",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x56,       0x56,       0x56,  std_patt_table},
 {"SERR",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x59,       0x59,       0x59,  std_patt_table},
 {"PERR",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x58,       0x58,       0x58,  std_patt_table},
 {"IDSEL",        0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x54,       0x54,       0x54,  std_patt_table},
 {"SBO",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x49,       0x49,       0x7D,  std_patt_table},
 {"SDONE",        0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x4A,       0x4A,       0x7E,  std_patt_table},
 {"berr",         0, 0x1,         1, B_PATT_STD,                                 0xAE, NO_BIT_POS,       0x66,  std_patt_table},
 {"data_cmperr",  0, 0x1,         1, B_PATT_STD,                                 0xAF, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"timing_err",   0, 0x1,         1, B_PATT_STD,                                          0xDC, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"INTA",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5C,       0x5C,       0x5C,  std_patt_table},
 {"INTB",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5D,       0x5D,       0x5D,  std_patt_table},
 {"INTC",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5E,       0x5E,       0x5E,  std_patt_table},
 {"INTD",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5F,       0x5F,       0x5F,  std_patt_table},
 {"m_marker",     0, 0xf,         4, B_PATT_STD,                                 0xA4, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {"t_marker",     0, 0xf,         4, B_PATT_STD,                                 0xA8, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {"xact_trig0",   0, 0x1,         1, B_PATT_STD,                                 0x60, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig1",   0, 0x1,         1, B_PATT_STD,                                 0x61, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig2",   0, 0x1,         1, B_PATT_STD,                                 0x62, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig3",   0, 0x1,         1, B_PATT_STD,                                 0x63, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig4",   0, 0x1,         1, B_PATT_STD,                                 0x64, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig5",   0, 0x1,         1, B_PATT_STD,                                 0x65, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig6",   0, 0x1,         1, B_PATT_STD,                                 0x66, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig7",   0, 0x1,         1, B_PATT_STD,                                 0x67, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig8",   0, 0x1,         1, B_PATT_STD,                                 0x68, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig9",   0, 0x1,         1, B_PATT_STD,                                 0x69, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig10",  0, 0x1,         1, B_PATT_STD,                                 0x6A, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig11",  0, 0x1,         1, B_PATT_STD,                                 0x6B, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_0",     0, 0x1,         1, B_PATT_STD,                                 0x98, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_1",     0, 0x1,         1, B_PATT_STD,                                 0x99, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_2",     0, 0x1,         1, B_PATT_STD,                                 0x9A, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_3",     0, 0x1,         1, B_PATT_STD,                                 0x9B, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_4",     0, 0x1,         1, B_PATT_STD,                                 0x9C, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_5",     0, 0x1,         1, B_PATT_STD,                                 0x9D, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_6",     0, 0x1,         1, B_PATT_STD,                                 0x9E, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_7",     0, 0x1,         1, B_PATT_STD,                                 0x9F, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"trigger0",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD0,       0x4E,       0x70,  std_patt_table},
 {"trigger1",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD1,       0x4F,       0x71,  std_patt_table},
 {"trigger2",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD2,       0x60,       0x72,  std_patt_table},
 {"trigger3",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD3,       0x61,       0x73,  std_patt_table},
 {"trigger4",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD4,       0x62,       0x74,  std_patt_table},
 {"trigger5",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD5,       0x63,       0x75,  std_patt_table},
 {"trigger6",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD6,       0x64,       0x76,  std_patt_table},
 {"trigger7",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD7,       0x65,       0x77,  std_patt_table},
 {"trigger8",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD8,       0x66,       0x78,  std_patt_table},
 {"trigger9",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD9,       0x67,       0x79,  std_patt_table},
 {"trigger10",    0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xDA,       0x68,       0x7A,  std_patt_table},
 {"trigger11",    0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xDB,       0x69,       0x7B,  std_patt_table},
 {"customrule0",  0, 0x1,         1, 0,  /* these are not used so far */         0x90, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule1",  0, 0x1,         1, 0,                                          0x91, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule2",  0, 0x1,         1, 0,                                          0x92, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule3",  0, 0x1,         1, 0,                                          0x93, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule4",  0, 0x1,         1, 0,                                          0x94, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule5",  0, 0x1,         1, 0,                                          0x95, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule6",  0, 0x1,         1, 0,                                          0x96, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule7",  0, 0x1,         1, 0,                                          0x97, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"i_marker",     0, 0x3,         2, 0,                                          0xAC, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {"CPU",          0, 0xf,         4, 0,                                          0xA0, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {NULL,           0,   0,         0, 0,  /* terminating line */            NO_BIT_POS, NO_BIT_POS, NO_BIT_POS,  NULL          } 
};

#endif

/* no difference between e2925b with and without deep trace */
#ifdef FIRMWARE_UX_COMPILE
extern b_patt_infotype e2925b_patt_signal_table[];
#else
#ifdef FIRMWARE_REAL_COMPILE
static
#endif
const b_patt_infotype e2925b_patt_signal_table[] = {
 {"AD32",         0, 0xffffffff, 32, B_PATT_STD | B_PATT_COND,                   0x20,       0x20,       0x20,  NULL          },
 {"CBE3_0",       0, 0xf,         4, B_PATT_STD | B_PATT_COND,                   0x40,       0x40,       0x40,  NULL          },
 {"FRAME",        0, 0x7,         1, B_PATT_STD | B_PATT_COND,                   0x50,       0x50,       0x50,  std_patt_table},
 {"IRDY",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x51,       0x51,       0x51,  std_patt_table},
 {"TRDY",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x52,       0x52,       0x52,  std_patt_table},
 {"STOP",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x55,       0x55,       0x55,  std_patt_table},
 {"DEVSEL",       0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x53,       0x53,       0x53,  std_patt_table},
 {"b_state",      0, 0x7,         3, B_PATT_STD,                                0x188, NO_BIT_POS,      0x148,  bstate_patt_table},
 {"xact_cmd",     0, 0xf,         4, B_PATT_STD               | B_PATT_SQ,      0x170, NO_BIT_POS, NO_BIT_POS,  xact_patt_table},
 {"PAR",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5A,       0x5A,       0x5A,  std_patt_table},
 {"t_act",        0, 0x1,         1, B_PATT_STD               | B_PATT_SQ,       0xC1, NO_BIT_POS,       0x64,  std_patt_table},
 {"m_act",        0, 0x1,         1, B_PATT_STD               | B_PATT_SQ,       0xC0, NO_BIT_POS,       0x62,  std_patt_table},
 {"m_lock",       0, 0x1,         1, B_PATT_STD,                                 0xC2, NO_BIT_POS,       0x63,  std_patt_table},
 {"t_lock",       0, 0x1,         1, B_PATT_STD,                                 0xC3, NO_BIT_POS,       0x65,  std_patt_table},
 {"xact_burst",   0, 0x3,         2, B_PATT_STD,                                0x16C, NO_BIT_POS, NO_BIT_POS,  x_burst_patt_table},
 {"term",         0, 0x7,         3, B_PATT_STD,                                0x180, NO_BIT_POS, NO_BIT_POS,  term_patt_table},
 {"burst",        0, 0x4,         3, B_PATT_STD,                                0x1B8, NO_BIT_POS, NO_BIT_POS,  burst_patt_table},
 {"decode",       0, 0x5,         3, B_PATT_STD,                                0x1B0, NO_BIT_POS, NO_BIT_POS,  decode_patt_table},
 {"xact_lock",    0, 0x1,         1, B_PATT_STD,                                 0xDF, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_dac",     0, 0x1,         1, B_PATT_STD,                                 0xDE, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_fb2b",    0, 0x1,         1, B_PATT_STD,                                 0xDD, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"master_done",  0, 0x1,         1, B_PATT_STD,                                 0xC4, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"addr_lt_ul",   0, 0x1,         1, 0,                                          0xC6, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"addr_bt_ll",   0, 0x1,         1, 0,                                          0xC5, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"addr_phase",   0, 0x1,         1,              B_PATT_COND,             NO_BIT_POS,       0x6A, NO_BIT_POS,  std_patt_table},
 {"RST",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5B,       0x5B,       0x5B,  std_patt_table},
 {"LOCK",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x48,       0x48,       0x7C,  std_patt_table},
 {"GNT",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x57,       0x57,       0x57,  std_patt_table},
 {"REQ",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x56,       0x56,       0x56,  std_patt_table},
 {"SERR",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x59,       0x59,       0x59,  std_patt_table},
 {"PERR",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x58,       0x58,       0x58,  std_patt_table},
 {"IDSEL",        0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x54,       0x54,       0x54,  std_patt_table},
 {"SBO",          0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x49,       0x49,       0x7D,  std_patt_table},
 {"SDONE",        0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x4A,       0x4A,       0x7E,  std_patt_table},
 {"berr",         0, 0x1,         1, B_PATT_STD,                                 0xAE, NO_BIT_POS,       0x66,  std_patt_table},
 {"data_cmperr",  0, 0x1,         1, B_PATT_STD,                                 0xAF, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"timing_err",   0, 0x1,         1, B_PATT_STD,                                          0xDC, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"INTA",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5C,       0x5C,       0x5C,  std_patt_table},
 {"INTB",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5D,       0x5D,       0x5D,  std_patt_table},
 {"INTC",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5E,       0x5E,       0x5E,  std_patt_table},
 {"INTD",         0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0x5F,       0x5F,       0x5F,  std_patt_table},
 {"m_marker",     0, 0xf,         4, B_PATT_STD,                                 0xA4, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {"t_marker",     0, 0xf,         4, B_PATT_STD,                                 0xA8, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {"xact_trig0",   0, 0x1,         1, B_PATT_STD,                                 0x60, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig1",   0, 0x1,         1, B_PATT_STD,                                 0x61, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig2",   0, 0x1,         1, B_PATT_STD,                                 0x62, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig3",   0, 0x1,         1, B_PATT_STD,                                 0x63, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig4",   0, 0x1,         1, B_PATT_STD,                                 0x64, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig5",   0, 0x1,         1, B_PATT_STD,                                 0x65, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig6",   0, 0x1,         1, B_PATT_STD,                                 0x66, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig7",   0, 0x1,         1, B_PATT_STD,                                 0x67, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig8",   0, 0x1,         1, B_PATT_STD,                                 0x68, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig9",   0, 0x1,         1, B_PATT_STD,                                 0x69, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig10",  0, 0x1,         1, B_PATT_STD,                                 0x6A, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"xact_trig11",  0, 0x1,         1, B_PATT_STD,                                 0x6B, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_0",     0, 0x1,         1, B_PATT_STD,                                 0x98, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_1",     0, 0x1,         1, B_PATT_STD,                                 0x99, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_2",     0, 0x1,         1, B_PATT_STD,                                 0x9A, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_3",     0, 0x1,         1, B_PATT_STD,                                 0x9B, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_4",     0, 0x1,         1, B_PATT_STD,                                 0x9C, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_5",     0, 0x1,         1, B_PATT_STD,                                 0x9D, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_6",     0, 0x1,         1, B_PATT_STD,                                 0x9E, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"static_7",     0, 0x1,         1, B_PATT_STD,                                 0x9F, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"trigger0",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD0,       0x4E,       0x70,  std_patt_table},
 {"trigger1",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD1,       0x4F,       0x71,  std_patt_table},
 {"trigger2",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD2,       0x60,       0x72,  std_patt_table},
 {"trigger3",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD3,       0x61,       0x73,  std_patt_table},
 {"trigger4",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD4,       0x62,       0x74,  std_patt_table},
 {"trigger5",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD5,       0x63,       0x75,  std_patt_table},
 {"trigger6",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD6,       0x64,       0x76,  std_patt_table},
 {"trigger7",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD7,       0x65,       0x77,  std_patt_table},
 {"trigger8",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD8,       0x66,       0x78,  std_patt_table},
 {"trigger9",     0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xD9,       0x67,       0x79,  std_patt_table},
 {"trigger10",    0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xDA,       0x68,       0x7A,  std_patt_table},
 {"trigger11",    0, 0x1,         1, B_PATT_STD | B_PATT_COND,                   0xDB,       0x69,       0x7B,  std_patt_table},
 {"customrule0",  0, 0x1,         1, 0,  /* these are not used so far */         0x90, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule1",  0, 0x1,         1, 0,                                          0x91, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule2",  0, 0x1,         1, 0,                                          0x92, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule3",  0, 0x1,         1, 0,                                          0x93, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule4",  0, 0x1,         1, 0,                                          0x94, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule5",  0, 0x1,         1, 0,                                          0x95, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule6",  0, 0x1,         1, 0,                                          0x96, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"customrule7",  0, 0x1,         1, 0,                                          0x97, NO_BIT_POS, NO_BIT_POS,  std_patt_table},
 {"i_marker",     0, 0x3,         2, 0,                                          0xAC, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {"CPU",          0, 0xf,         4, 0,                                          0xA0, NO_BIT_POS, NO_BIT_POS,  NULL          },
 {NULL,           0,   0,         0, 0,  /* terminating line */            NO_BIT_POS, NO_BIT_POS, NO_BIT_POS,  NULL          } 
};

#endif
